<?php
use voku\helper\AntiXSS;
session_start();
date_default_timezone_set('Europe/Istanbul'); // Lokasyon Tarih Saat Ayarı
$tarih 	= time();							// Şimdinin Tarih Bilgilerini  Alır
$site 	= 'https://morpo.bwebeticaret.com.tr/';   // Web Site Url
$ssl 	= 'on'; 						  // $ssl = 'on or off';
$www 	= 'off'; 					     // $www = 'on or off';

$dizinbul = str_replace('admin','',__DIR__);
require_once $dizinbul.'vendor/autoload.php';

try {
	$db = new PDO('mysql:host=localhost;dbname=bwebeti1_morpo;charset=utf8', 'bwebeti1_morpo','bwebeti1_morpo');
} catch (PDOException $e){
	die($e->getMessage());
}

include 'fonksiyon.php';

// Admin Girişi Yoksa SQL Injection Saldırılarını ve XSS Ataklarını Engeller
if(!isset($_SESSION['admin']['giris'])){
	$antiXss = new AntiXSS();
	foreach($_GET as $k => $v){
		if(is_array($v)){
	        foreach ($s as $s_key=>$s_val) {
	            $v[$s_key] = clean_string($s_val);
	        }
	    }else{
	    	$_GET[$k] = $antiXss->xss_clean($v);
			if($antiXss->isXssFound()){
				$atak_yapilan_link = $_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
				$ekle = $db->prepare("INSERT INTO guvenlik_log SET ip = ?, tarih = ?, atak_yapilan_link = ?");
		    	$ekle = $ekle->execute(array(ip(),$tarih,$atak_yapilan_link));
			}
			$_GET[$k] = temizle($v);
	    }
	} 
	foreach($_POST as $k => $v){
		if(is_array($v)){
	        foreach ($s as $s_key=>$s_val) {
	            $v[$s_key] = clean_string($s_val);
	        }
	    }else{
	    	$_POST[$k] = $antiXss->xss_clean($v);
			if($antiXss->isXssFound()){
				$atak_yapilan_link = $_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
				$ekle = $db->prepare("INSERT INTO guvenlik_log SET ip = ?, tarih = ?, atak_yapilan_link = ?");
		    	$ekle = $ekle->execute(array(ip(),$tarih,$atak_yapilan_link));
			}
			$_POST[$k] = temizle($v);
	    }
	}
}

$kur_kontrol = $db->query("SELECT * FROM ayar LIMIT 1")->fetch(PDO::FETCH_ASSOC);
if($kur_kontrol){
	if((($tarih - $kur_kontrol['kur_tarih']) / 120) > 120){
		$tcmb 	= simplexml_load_file('http://www.tcmb.gov.tr/kurlar/today.xml');
		$euro 	= $tcmb->Currency[3]->BanknoteSelling;
		$dolar 	= $tcmb->Currency[0]->BanknoteSelling;
		if(!empty($euro) AND !empty($dolar)){
			$guncelle = $db->prepare("UPDATE ayar SET euro = ?, dolar = ?, kur_tarih = ?");
	   		$guncelle = $guncelle->execute(array($euro,$dolar,$tarih));
		}
	}
}

$kur_tipi = array(1 => 'TL', 2 => '$', 3 => '€');
$indirim_tipi = array(1 => '+', 2 => '-', 3 => '+%', 4 => '-%');
$odeme_yontemleri = array(1 => 'Online Kredi Kartı', 2 => 'Banka Havalesi', 3 => 'Kapıda Nakit Ödeme', 4 => 'Kapıda Kredi Kartı Ödeme');
?>